/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ConfigDataHolder;
import fuzs.puzzleslib.config.ValueCallback;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigDataHolderImpl<T extends ConfigCore>
implements ConfigDataHolder<T>,
ValueCallback {
    protected final T config;
    private final Supplier<T> defaultConfigSupplier;
    @Nullable
    private T defaultConfig;
    protected UnaryOperator<String> fileName;
    protected final List<Runnable> additionalCallbacks = Lists.newArrayList();
    protected List<Runnable> configValueCallbacks = Lists.newArrayList();
    protected boolean available;

    protected ConfigDataHolderImpl(Supplier<T> config) {
        this.config = (ConfigCore)config.get();
        this.defaultConfigSupplier = config;
    }

    @Override
    public T config() {
        return this.isAvailable() ? this.config : this.getOrCreateDefaultConfig();
    }

    private T getOrCreateDefaultConfig() {
        if (this.defaultConfig == null) {
            this.testAvailable();
            this.defaultConfig = (ConfigCore)this.defaultConfigSupplier.get();
        }
        return this.defaultConfig;
    }

    @Override
    public boolean isAvailable() {
        return this.findErrorMessage().left().isPresent();
    }

    @Override
    public void accept(Runnable callback) {
        this.additionalCallbacks.add(callback);
    }

    public <V> void accept(Supplier<V> entry, Consumer<V> save) {
        this.configValueCallbacks.add(() -> save.accept(entry.get()));
    }

    public void setFileName(UnaryOperator<String> fileName) {
        this.fileName = fileName;
    }

    protected abstract void testAvailable();

    protected abstract Either<Unit, String> findErrorMessage();
}

